///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ScanningDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND ANIPlaceHolder_hWnd = NULL;
    static HWND StaticText1_hWnd    = NULL;
    
    static HFONT LinksFontHandle    = NULL;

    static DWORD RGBStatic, SystemBGColor;

    if(xMessage == WM_INITDIALOG) // Received a initilize dialog message
    {
        ScanningDialog_hWnd = xHandle;

        SendMessage(ScanningDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)TitleCaption" :: Scanning");
        SendMessage(ScanningDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(IDI_MAIN)));

        ANIPlaceHolder_hWnd = GetDlgItem(ScanningDialog_hWnd, IDC_ANIPLACEHOLDER);
        StaticText1_hWnd = GetDlgItem(ScanningDialog_hWnd, IDC_STATIC1);
        StatusText_hWnd = GetDlgItem(ScanningDialog_hWnd, IDC_STATUSTEXT);

        HCURSOR IconHandle = LoadIcon(MainInstance,MAKEINTRESOURCE(IDR_WORKINGANI));
        SendMessage(ANIPlaceHolder_hWnd, (UINT)STM_SETIMAGE, (WPARAM)IMAGE_ICON, (LPARAM)IconHandle);

        LinksFontHandle = MakeFont("MS Sans Serif", 14);

        SetFont(StaticText1_hWnd, LinksFontHandle);

        RGBStatic = RGB(128, 0, 128);
        SystemBGColor = GetSysColor(COLOR_3DFACE);

        CenterWindow(ScanningDialog_hWnd);

        POPGrid_Thread_Handle = CreateThread(NULL, 0, POPGrid_Thread, (LPVOID)0, 0, &POPGrid_Thread_ID);

        return TRUE;
    }

    if(xMessage == WM_CTLCOLORSTATIC)
    {
        if((HANDLE)lParam == StaticText1_hWnd)
            return Set_Color(RGBStatic, SystemBGColor, wParam);
    }

    if(xMessage == WM_COMMAND) // Received a message
    {
        if(wParam == IDC_CANCELBUTTON)
        {
            SuspendThread(POPGrid_Thread_Handle);
            TerminateThread(POPGrid_Thread_Handle, 0);
            CloseHandle(POPGrid_Thread_Handle);
            EndDialog(ScanningDialog_hWnd, 1);
        }
        return TRUE;
    }

    if(xMessage == WM_CLOSE)  // Received close message
    {
        EndDialog(ScanningDialog_hWnd, 0);
    }

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

